const express = require("express");
const cors = require("cors");
const path = require("path");
const { OpenAI } = require("openai");

const app = express();
app.use(cors());
app.use(express.json());

// Serve static files from the directory where chat.html is located
app.use(express.static(__dirname));

// OpenAI setup
const openai = new OpenAI({
  apiKey: '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'
});
const assistant_id = "asst_TcmAvBLYZYYqTzuv3G9XVExi"; // Replace with your Assistant ID

// Serve chat.html on root path
app.get("/", (req, res) => {
  res.sendFile(path.join(__dirname, "chat.html"));
});

// API endpoint to interact with Assistant
app.post("/api/chat", async (req, res) => {
  try {
    const userMessage = req.body.message;
    console.log("Received:", userMessage);

    const thread = await openai.beta.threads.create();
    await openai.beta.threads.messages.create(thread.id, {
      role: "user",
      content: userMessage,
    });

    const run = await openai.beta.threads.runs.create(thread.id, {
      assistant_id,
    });

    // Wait until assistant responds
    let runStatus;
    do {
      await new Promise((r) => setTimeout(r, 1000));
      runStatus = await openai.beta.threads.runs.retrieve(thread.id, run.id);
    } while (runStatus.status !== "completed");

    const messages = await openai.beta.threads.messages.list(thread.id);
    const response = messages.data.find((m) => m.role === "assistant");

    if (!response || !response.content || !response.content.length) {
      return res.json({ reply: "⚠️ Assistant did not return a response." });
    }

    res.json({ reply: response.content[0].text.value });
  } catch (err) {
    console.error("Error:", err.message);
    res.status(500).json({ error: "Error communicating with Assistant." });
  }
});

// Start server
app.listen(3000, () => {
  console.log("Server running on http://localhost:3000");
});
